/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.component;

import com.nyfaria.numismaticoverhaul.owostuff.ui.component.SliderComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModel;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIParsing;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import net.minecraft.network.chat.Component;
import org.w3c.dom.Element;

public class DiscreteSliderComponent
extends SliderComponent {
    protected double min;
    protected double max;
    protected int decimalPlaces = 0;
    protected boolean snap = false;

    protected DiscreteSliderComponent(Sizing horizontalSizing, double min, double max) {
        super(horizontalSizing);
        this.min = min;
        this.max = max;
        this.m_5695_();
        this.message(Component::m_237113_);
    }

    @Override
    protected void m_5697_() {
        this.listeners.set(this.discreteValue());
    }

    @Override
    protected void m_5695_() {
        this.m_93666_((Component)this.messageProvider.apply(String.format("%." + this.decimalPlaces + "f", this.discreteValue())));
    }

    public double discreteValue() {
        return new BigDecimal(this.min + this.f_93577_ * (this.max - this.min)).setScale(this.decimalPlaces, RoundingMode.HALF_UP).doubleValue();
    }

    public DiscreteSliderComponent setFromDiscreteValue(double discreteValue) {
        this.value((discreteValue - this.min) / (this.max - this.min));
        return this;
    }

    public DiscreteSliderComponent decimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    public int decimalPlaces() {
        return this.decimalPlaces;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public DiscreteSliderComponent snap(boolean snap) {
        this.snap = snap;
        return this;
    }

    public boolean snap() {
        return this.snap;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "decimal-places", UIParsing::parseUnsignedInt, this::decimalPlaces);
        UIParsing.apply(children, "value", UIParsing::parseDouble, this::setFromDiscreteValue);
    }

    public static DiscreteSliderComponent parse(Element element) {
        UIParsing.expectAttributes(element, "min", "max");
        return new DiscreteSliderComponent(Sizing.content(), UIParsing.parseDouble(element.getAttributeNode("min")), UIParsing.parseDouble(element.getAttributeNode("max")));
    }
}

